public struct AxisCount { public int even; public int odd; }
internal class Program {
    static void Main(string[] args) {
        int count = int.Parse(Console.ReadLine());
        Dictionary<int, int> hashmap1 = new Dictionary<int, int>();
        Dictionary<int, int> hashmap2 = new Dictionary<int, int>();
        Dictionary<int, AxisCount> hashmapX = new Dictionary<int, AxisCount>();
        Dictionary<int, AxisCount> hashmapY = new Dictionary<int, AxisCount>();

        for (int i = 0; i < count; i++) {
            string[] inputs = Console.ReadLine().Split();
            int x = int.Parse(inputs[0]);
            int y = int.Parse(inputs[1]);
            hashmap1[x - y]++;
            hashmap2[x + y]++;
            if (!hashmapX.ContainsKey(x)) hashmapX[x] = new AxisCount();
            if (!hashmapY.ContainsKey(y)) hashmapY[y] = new AxisCount();
            AxisCount axisCountX = hashmapX[x];
            AxisCount axisCountY = hashmapY[y];
            if (y % 2 == 0) axisCountX.even++;
            else axisCountX.odd++;
            if (x % 2 == 0) axisCountY.even++;
            else axisCountY.odd++;
        }

        int greetings = 0;
        foreach (int coordCount in hashmap1.Values)
            greetings += coordCount * (coordCount - 1);
        foreach (int coordCount in hashmap2.Values)
            greetings += coordCount * (coordCount - 1);
        foreach (AxisCount coordCount in hashmapX.Values)
            greetings += (coordCount.even * (coordCount.even - 1) + coordCount.odd * (coordCount.odd - 1)) / 2;
        foreach (AxisCount coordCount in hashmapY.Values)
            greetings += (coordCount.even * (coordCount.even - 1) + coordCount.odd * (coordCount.odd - 1)) / 2;
    }
}